/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWSelectParametersParentFrame;
import filenet.vw.toolkit.design.property.steps.VWParameterItem;
import filenet.vw.toolkit.design.property.steps.VWParametersAddRemovePanel;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWSelectParametersPanel
extends JPanel
implements ActionListener,
DocumentListener,
IVWPropertyChangeListener,
IVWSelectParametersParentFrame {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_stepDefinition = null;
    private JCheckBox m_fieldsCheckBox = null;
    private JCheckBox m_attachmentsCheckBox = null;
    private JCheckBox m_wflGroupsCheckBox = null;
    private JCheckBox m_xmlFieldsCheckBox = null;
    private VWParametersAddRemovePanel m_parametersAddRemovePanel = null;
    private JTextArea m_descriptionTextArea = null;

    public VWSelectParametersPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_fieldsCheckBox) {
                this.m_parametersAddRemovePanel.displayFields(this.m_fieldsCheckBox.isSelected());
            } else if (source == this.m_attachmentsCheckBox) {
                this.m_parametersAddRemovePanel.displayAttachments(this.m_attachmentsCheckBox.isSelected());
            } else if (source == this.m_wflGroupsCheckBox) {
                this.m_parametersAddRemovePanel.displayWorkflowGroups(this.m_wflGroupsCheckBox.isSelected());
            } else if (source == this.m_xmlFieldsCheckBox) {
                this.m_parametersAddRemovePanel.displayXMLFields(this.m_xmlFieldsCheckBox.isSelected());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            switch (event.getID()) {
                case 506: 
                case 508: 
                case 509: 
                case 511: 
                case 513: 
                case 514: 
                case 553: 
                case 558: 
                case 560: 
                case 561: 
                case 563: 
                case 564: 
                case 565: {
                    IVWPropertyChangeSource source = (IVWPropertyChangeSource)event.getSource();
                    Vector changedItemsList = source.getItemsChanged();
                    if (changedItemsList == null || changedItemsList.isEmpty()) {
                        return;
                    }
                    this.setSelectedStep(this.m_stepDefinition);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void updateAvailableParameterProperties(VWParameterItem param) {
        try {
            if (param != null) {
                VWFieldDefinition fieldDef = param.getFieldDefinition();
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.setText(fieldDef.getDescription());
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            } else {
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.setText("");
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            }
            this.m_descriptionTextArea.setEditable(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void updateSelectedParameterProperties(VWParameterItem param) {
        VWParameterDefinition paramDef = null;
        try {
            if (param != null) {
                paramDef = param.getParameterDefinition();
            }
            this.updateParameterProperties(paramDef);
            this.m_descriptionTextArea.setEditable(paramDef != null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void updateParameterProperties(VWParameterDefinition paramDef) {
        try {
            if (paramDef != null) {
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.setText(paramDef.getDescription());
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            } else {
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.setText("");
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            }
            this.m_descriptionTextArea.setEditable(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setSelectedStep(VWStepDefinition stepDefinition) {
        try {
            this.m_stepDefinition = stepDefinition;
            this.m_parametersAddRemovePanel.setSelectedStep(stepDefinition);
            if (this.m_stepDefinition != null) {
                this.m_parametersAddRemovePanel.displayFields(this.m_fieldsCheckBox.isSelected());
                this.m_parametersAddRemovePanel.displayAttachments(this.m_attachmentsCheckBox.isSelected());
                this.m_parametersAddRemovePanel.displayWorkflowGroups(this.m_wflGroupsCheckBox.isSelected());
                this.m_parametersAddRemovePanel.displayXMLFields(this.m_xmlFieldsCheckBox.isSelected());
            }
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            this.m_parametersAddRemovePanel.emptyLists();
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.setText("");
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.setEditable(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_attachmentsCheckBox != null) {
            this.m_attachmentsCheckBox.removeActionListener(this);
            this.m_attachmentsCheckBox.removeAll();
            this.m_attachmentsCheckBox = null;
        }
        if (this.m_fieldsCheckBox != null) {
            this.m_fieldsCheckBox.removeActionListener(this);
            this.m_fieldsCheckBox.removeAll();
            this.m_fieldsCheckBox = null;
        }
        if (this.m_xmlFieldsCheckBox != null) {
            this.m_xmlFieldsCheckBox.removeActionListener(this);
            this.m_xmlFieldsCheckBox.removeAll();
            this.m_xmlFieldsCheckBox = null;
        }
        if (this.m_parametersAddRemovePanel != null) {
            this.m_parametersAddRemovePanel.releaseReferences();
            this.m_parametersAddRemovePanel = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea = null;
        }
        this.m_stepDefinition = null;
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(new VWTitledBorder(VWResource.s_parametersTabStr));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 2;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 10, 2, 10);
            this.add((Component)this.createFilterPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            this.m_parametersAddRemovePanel = new VWParametersAddRemovePanel(this, this.m_authPropertyData);
            this.m_parametersAddRemovePanel.enableSorting(768);
            this.m_parametersAddRemovePanel.displayFields(true);
            this.m_parametersAddRemovePanel.displayAttachments(true);
            this.m_parametersAddRemovePanel.displayWorkflowGroups(true);
            this.m_parametersAddRemovePanel.displayXMLFields(true);
            this.add((Component)this.m_parametersAddRemovePanel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 2, 0);
            this.add((Component)this.getDescriptionPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createFilterPanel() {
        try {
            JPanel filterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 5, 0);
            filterPanel.add((Component)new JLabel(VWResource.s_show), gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 0, 3, 0);
            this.m_fieldsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("checkbox_fields_off.gif"));
            this.m_fieldsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("checkbox_fields_on.gif"));
            this.m_fieldsCheckBox.setToolTipText(VWResource.s_showHideDataFieldsStr);
            this.m_fieldsCheckBox.doClick();
            this.m_fieldsCheckBox.addActionListener(this);
            filterPanel.add((Component)this.m_fieldsCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_attachmentsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("checkbox_attachments_off.gif"));
            this.m_attachmentsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("checkbox_attachments_on.gif"));
            this.m_attachmentsCheckBox.setToolTipText(VWResource.s_showHideAttachmentsStr);
            this.m_attachmentsCheckBox.doClick();
            this.m_attachmentsCheckBox.addActionListener(this);
            filterPanel.add((Component)this.m_attachmentsCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_wflGroupsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("checkbox_wfgroups_off.gif"));
            this.m_wflGroupsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("checkbox_wfgroups_on.gif"));
            this.m_wflGroupsCheckBox.setToolTipText(VWResource.s_showHideWorkflowGroupsStr);
            this.m_wflGroupsCheckBox.doClick();
            this.m_wflGroupsCheckBox.addActionListener(this);
            filterPanel.add((Component)this.m_wflGroupsCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_xmlFieldsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("checkbox_xml_fields_off.gif"));
            this.m_xmlFieldsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("checkbox_xml_fields_on.gif"));
            this.m_xmlFieldsCheckBox.setToolTipText(VWResource.s_showHideXMLFieldsStr);
            this.m_xmlFieldsCheckBox.doClick();
            this.m_xmlFieldsCheckBox.addActionListener(this);
            filterPanel.add((Component)this.m_xmlFieldsCheckBox, gbCons);
            return filterPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getDescriptionPanel() {
        try {
            JPanel descriptionPanel = new JPanel(new BorderLayout(6, 6));
            descriptionPanel.add((Component)new JLabel(VWResource.s_prompt), "First");
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(3);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.setEditable(false);
            descriptionPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return descriptionPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleDocumentEvent(DocumentEvent event) {
        try {
            VWParameterDefinition paramDef;
            String paramName;
            if (this.m_stepDefinition == null || this.m_parametersAddRemovePanel == null) {
                return;
            }
            if (event.getDocument() == this.m_descriptionTextArea.getDocument() && (paramName = this.m_parametersAddRemovePanel.getSelectedParameterName()) != null && (paramDef = this.m_stepDefinition.getParameterDefinition(paramName)) != null) {
                paramDef.setDescription(this.m_descriptionTextArea.getText());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

